/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.entity;

import java.util.Optional;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.hecco.bountifulfares.BountifulFares;
import net.hecco.bountifulfares.block.custom.GristmillBlock;
import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.hecco.bountifulfares.block.entity.ImplementedInventory;
import net.hecco.bountifulfares.recipe.MillingRecipe;
import net.hecco.bountifulfares.screen.GristmillScreenHandler;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class GristmillBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory,
ImplementedInventory {
    private static class_2746 millingState;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private static final int[] TOP_SLOTS;
    private static final int[] BOTTOM_SLOTS;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final class_3913 propertyDelegate;
    private int progress = 0;
    private int maxProgress = 80;

    public GristmillBlockEntity(class_2338 pos, class_2680 state) {
        super(BFBlockEntities.GRISTMILL_BLOCK_ENTITY, pos, state);
        millingState = ((GristmillBlock)state.method_26204()).getMillingState();
        this.propertyDelegate = new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0 -> GristmillBlockEntity.this.progress;
                    case 1 -> GristmillBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: {
                        GristmillBlockEntity.this.progress = value;
                    }
                    case 1: {
                        GristmillBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int method_17389() {
                return 2;
            }
        };
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.bountifulfares.gristmill");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new GristmillScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("milling.progress", this.progress);
    }

    public void method_11014(class_2487 nbt) {
        class_1262.method_5429((class_2487)nbt, this.inventory);
        nbt.method_10550("milling.progress");
        super.method_11014(nbt);
    }

    private boolean isCrafting() {
        return this.hasRecipe() && this.canInsertOutputSlot();
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            if (this.maxProgress != BountifulFares.CONFIG.getMillingTime() * 20) {
                this.maxProgress = BountifulFares.CONFIG.getMillingTime() * 20;
            }
            if (!((Boolean)state.method_11654((class_2769)millingState)).booleanValue() && !((class_1799)this.inventory.get(0)).method_7960() && this.isCrafting()) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)millingState, (Comparable)Boolean.valueOf(true)));
            }
            if (((Boolean)state.method_11654((class_2769)millingState)).booleanValue() && !this.hasRecipe() && this.progress != 0) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)millingState, (Comparable)Boolean.valueOf(false)));
            }
            if (this.canInsertOutputSlot() && this.hasRecipe()) {
                this.increaseCraftingProgress();
                GristmillBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                if (this.hasCraftingFinished()) {
                    this.craftItem();
                    this.resetProgress();
                }
            } else {
                this.decreaseCraftingProgress();
            }
        }
    }

    private void resetProgress() {
        this.progress = 1;
    }

    private void craftItem() {
        Optional<MillingRecipe> recipe = this.getCurrentRecipe();
        this.method_5434(0, 1);
        this.method_5447(1, new class_1799((class_1935)recipe.get().method_8110(null).method_7909(), this.method_5438(1).method_7947() + recipe.get().method_8110(null).method_7947()));
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private void decreaseCraftingProgress() {
        if (this.progress > 0) {
            this.progress -= 2;
        }
    }

    private boolean hasRecipe() {
        Optional<MillingRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        class_1799 output = recipe.get().method_8110(null);
        return this.canInsertAmountIntoOutputSlot(output.method_7947()) && this.canInsertItemIntoOutputSlot(output);
    }

    private boolean canInsertItemIntoOutputSlot(class_1799 output) {
        return this.method_5438(1).method_7960() || this.method_5438(1).method_7909() == output.method_7909();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        return this.method_5438(1).method_7914() >= this.method_5438(1).method_7947() + count;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return BOTTOM_SLOTS;
        }
        if (side == class_2350.field_11036) {
            return TOP_SLOTS;
        }
        return TOP_SLOTS;
    }

    private Optional<MillingRecipe> getCurrentRecipe() {
        class_1277 inventory = new class_1277(this.method_5439());
        for (int i = 0; i < this.method_5439(); ++i) {
            inventory.method_5447(i, this.method_5438(i));
        }
        return this.method_10997().method_8433().method_8132((class_3956)MillingRecipe.Type.INSTANCE, (class_1263)inventory, this.method_10997());
    }

    private boolean canInsertOutputSlot() {
        return this.method_5438(1).method_7960() || this.method_5438(1).method_7947() < this.method_5438(1).method_7914();
    }

    static {
        TOP_SLOTS = new int[]{0};
        BOTTOM_SLOTS = new int[]{1};
    }
}

